// math

new const Float:VEC_NULL[3] = {0.0, 0.0, 0.0};

stock sign(const Float:flValue)
{
	if(flValue > 0.0)
		return 1;
	else if(flValue < 0.0)
		return -1;

	return 0;
}

stock is_zero_vec(const Float:flVec[3])
{
	return (flVec[0] == 0 && flVec[1] == 0 && flVec[2] == 0);
}

stock are_vectors_equal(const Float:flVec1[3], const Float:flVec2[3])
{
	return (flVec1[0] == flVec2[0] && flVec1[1] == flVec2[1] && flVec1[2] == flVec2[2]);
}

stock are_vectors_almost_equal(const Float:flVec1[3], const Float:flVec2[3], const Float:flDelta)
{
	return (floatabs(flVec1[0] - flVec2[0]) < flDelta && floatabs(flVec1[1] - flVec2[1]) < flDelta && floatabs(flVec1[2] - flVec2[2]) < flDelta)
}

stock vector_normalization(const Float:flVec1[3], Float:flVec2[3])
{
	new Float:flMod = flVec1[0] * flVec2[0] + flVec1[1] * flVec2[1] + flVec1[2] * flVec2[2];
	if(flMod > 0.0)
	{
		flMod = floatsqroot(flMod);
		flVec2[0] = flVec1[0] / flMod;
		flVec2[1] = flVec1[1] / flMod;
		flVec2[2] = flVec1[2] / flMod;
	}
	else
	{
		flVec2[0] = 0.0;
		flVec2[1] = 0.0;
		flVec2[2] = 0.0;
	}
}

stock vector_normalization_self(Float:flVec[3])
{
	new Float:flMod = flVec[0] * flVec[0] + flVec[1] * flVec[1] + flVec[2] * flVec[2];
	if(flMod > 0.0)
	{
		flMod = floatsqroot(flMod);
		flVec[0] /= flMod;
		flVec[1] /= flMod;
		flVec[2] /= flMod;
	}
	else
	{
		flVec[0] = 0.0;
		flVec[1] = 0.0;
		flVec[2] = 0.0;
	}
}

stock vector_copy(const Float:flVec1[3], Float:flVec2[3])
{
	flVec2[0] = flVec1[0];
	flVec2[1] = flVec1[1];
	flVec2[2] = flVec1[2];
}

stock vector_sum(const Float:flVec1[3], const Float:flVec2[3], Float:flVec3[3])
{
	flVec3[0] = flVec1[0] + flVec2[0];
	flVec3[1] = flVec1[1] + flVec2[1];
	flVec3[2] = flVec1[2] + flVec2[2];
}

stock vector_sum_self(const Float:flVec1[3], Float:flVec2[3])
{
	flVec2[0] = flVec1[0] + flVec2[0];
	flVec2[1] = flVec1[1] + flVec2[1];
	flVec2[2] = flVec1[2] + flVec2[2];
}

stock vector_dif(const Float:flVec1[3], const Float:flVec2[3], Float:flVec3[3])
{
	flVec3[0] = flVec1[0] - flVec2[0];
	flVec3[1] = flVec1[1] - flVec2[1];
	flVec3[2] = flVec1[2] - flVec2[2];
}

stock vector_dif_self(const Float:flVec1[3], Float:flVec2[3])
{
	flVec2[0] = flVec1[0] - flVec2[0];
	flVec2[1] = flVec1[1] - flVec2[1];
	flVec2[2] = flVec1[2] - flVec2[2];
}

stock Float:vector_hor_length(const Float:flVec[3])
{
	new Float:flNorma = flVec[0] * flVec[0] + flVec[1] * flVec[1];
	return (flNorma > 0.0 ? floatsqroot(flNorma) : 0.0);
}

stock Float:vector_hor_distance(const Float:flVec1[3], const Float:flVec2[3])
{
	new Float:flNorma = (flVec2[0] - flVec1[0]) * (flVec2[0] - flVec1[0]) + (flVec2[1] - flVec1[1]) * (flVec2[1] - flVec1[1]);
	return (flNorma > 0.0 ? floatsqroot(flNorma) : 0.0);
}

stock vector_scale(const Float:flVec1[3], const Float:flFactor, Float:flVec2[3])
{
	flVec2[0] = flVec1[0] * flFactor;
	flVec2[1] = flVec1[1] * flFactor;
	flVec2[2] = flVec1[2] * flFactor;
}

stock vector_scale_self(const Float:flFactor, Float:flVec[3])
{
	flVec[0] *= flFactor;
	flVec[1] *= flFactor;
	flVec[2] *= flFactor;
}

stock Float:vector_dot(const Float:flVec1[3], const Float:flVec2[3])
{
	return (flVec1[0] * flVec2[0] + flVec1[1] * flVec2[1] + flVec1[2] * flVec2[2]);
}

stock vector_cross(const Float:flVec1[3], const Float:flVec2[3], Float:flVec3[3])
{
	flVec3[0] = flVec1[1] * flVec2[2] - flVec1[2] * flVec2[1];
	flVec3[1] = flVec1[2] * flVec2[0] - flVec1[0] * flVec2[2];
	flVec3[2] = flVec1[0] * flVec2[1] - flVec1[1] * flVec2[0];
}

// positioning

stock get_player_position(id, Float:flOrigin[3], Float:flAngles[3], &Float:flGravity)
{
	pev(id, pev_origin, flOrigin);
	pev(id, pev_v_angle, flAngles);
	pev(id, pev_gravity, flGravity);
}

stock get_player_origin(const id, Float:flOrigin[3], Float:flAngles[3], &Float:flGravity, &Float:flFuser2)
{
	pev(id, pev_origin, flOrigin);
	pev(id, pev_v_angle, flAngles);
	pev(id, pev_gravity, flGravity);
	pev(id, pev_fuser2, flFuser2);
}

stock set_player_origin(const id, const Float:flOrigin[3], const Float:flAngles[3], const Float:flGravity = 1.0, const Float:flFuser2 = 0.0)
{
	new iFlags = pev(id, pev_flags); 
	iFlags &= ~FL_BASEVELOCITY;					// in case player was on conveyor 
	iFlags |= FL_DUCKING;						// prevent stuck 
	set_pev(id, pev_flags, iFlags);

	new Float:VEC_DUCK_HULL_MIN[3]	= {-16.0, -16.0, -18.0 };
	new Float:VEC_DUCK_HULL_MAX[3]	= { 16.0,  16.0,  32.0 };
	new Float:VEC_DUCK_VIEW[3]      = { 0.0,   0.0,   12.0 };
	
	engfunc(EngFunc_SetSize, id, VEC_DUCK_HULL_MIN, VEC_DUCK_HULL_MAX);	// prevent stuck 
	engfunc(EngFunc_SetOrigin, id, flOrigin);
	set_pev(id, pev_view_ofs, VEC_DUCK_VIEW); 

	set_pev(id, pev_velocity, VEC_NULL);		// reset speed 
	set_pev(id, pev_basevelocity, VEC_NULL);	// reset speed 
	if(flGravity != 0.0)
		set_pev(id, pev_gravity, flGravity);	
	set_pev(id, pev_fuser2, flFuser2);			

	if(!is_zero_vec(flAngles))
	{
		set_pev(id, pev_v_angle, VEC_NULL);		// reset v_angle so it will match angles 
		set_pev(id, pev_angles, flAngles);		// set view 
		set_pev(id, pev_punchangle, VEC_NULL);	// reset 
		set_pev(id, pev_fixangle, 1);			// update v_angle (and angles?) 
	}
}

// beams

stock draw_line(id, hBeam, Float:x1, Float:y1, Float:z1, Float:x2, Float:y2, Float:z2, r = 255, g = 255, b = 255, iLife = 1, iWidth = 10)
{
	message_begin(id ? MSG_ONE_UNRELIABLE : MSG_BROADCAST, SVC_TEMPENTITY, _, id ? id : 0);
	write_byte(TE_BEAMPOINTS);
	write_coord(floatround(x1));
	write_coord(floatround(y1));
	write_coord(floatround(z1));
	write_coord(floatround(x2));
	write_coord(floatround(y2));
	write_coord(floatround(z2));
	write_short(hBeam); // sprite
	write_byte(1); // framestart
	write_byte(1); // framerate
	write_byte(iLife); // life
	write_byte(iWidth); // width
	write_byte(0); // noise
	write_byte(r);
	write_byte(g);
	write_byte(b);
	write_byte(230); // brightness
	write_byte(0); // speed
	message_end();
}

stock draw_beam(id, hBeam, Float:flPoint1[3], Float:flPoint2[3], r = 255, g = 255, b = 255, iLife = 1, iWidth = 10)
{
	draw_line(id, hBeam, flPoint1[0], flPoint1[1], flPoint1[2], flPoint2[0], flPoint2[1], flPoint2[2], r, g, b, iLife, iWidth);
}

stock draw_quad(id, hBeam, Float:flCenter[3], Float:flHalfside, r = 255, g = 255, b = 255, iLife = 1, iWidth = 10)
{
	draw_line(id, hBeam, flCenter[0] - flHalfside, flCenter[1] + flHalfside, flCenter[2], flCenter[0] - flHalfside, flCenter[1] - flHalfside, flCenter[2], r, g, b, iLife, iWidth);
	draw_line(id, hBeam, flCenter[0] - flHalfside, flCenter[1] - flHalfside, flCenter[2], flCenter[0] + flHalfside, flCenter[1] - flHalfside, flCenter[2], r, g, b, iLife, iWidth);
	draw_line(id, hBeam, flCenter[0] + flHalfside, flCenter[1] - flHalfside, flCenter[2], flCenter[0] + flHalfside, flCenter[1] + flHalfside, flCenter[2], r, g, b, iLife, iWidth);
	draw_line(id, hBeam, flCenter[0] + flHalfside, flCenter[1] + flHalfside, flCenter[2], flCenter[0] - flHalfside, flCenter[1] + flHalfside, flCenter[2], r, g, b, iLife, iWidth);
}

// commands

stock register_cmd(command[], function[], flags = -1, info[] = "") 
{
	new szTemp[64];

	formatex(szTemp, charsmax(szTemp), "say /%s", command);
	register_clcmd(szTemp, function, flags, info);
	
	formatex(szTemp, charsmax(szTemp), "say .%s", command);
	register_clcmd(szTemp, function, flags, info);
	
	formatex(szTemp, charsmax(szTemp), "say_team /%s", command);
	register_clcmd(szTemp, function, flags, info);
	
	formatex(szTemp, charsmax(szTemp), "say_team .%s", command);
	register_clcmd(szTemp, function, flags, info);
	
	formatex(szTemp, charsmax(szTemp), "/%s", command);
	register_clcmd(szTemp, function, flags, info);
	
	formatex(szTemp, charsmax(szTemp), ".%s", command);
	register_clcmd(szTemp, function, flags, info);
}

stock register_saycmd(command[], function[], flags = -1, info[] = "") 
{
	new szTemp[64];

	formatex(szTemp, charsmax(szTemp), "say /%s", command);
	register_clcmd(szTemp, function, flags, info);
	
	formatex(szTemp, charsmax(szTemp), "say .%s", command);
	register_clcmd(szTemp, function, flags, info);
	
	formatex(szTemp, charsmax(szTemp), "say_team /%s", command);
	register_clcmd(szTemp, function, flags, info);
	
	formatex(szTemp, charsmax(szTemp), "say_team .%s", command);
	register_clcmd(szTemp, function, flags, info);
}

stock send_cmd(id, text[])
{
	message_begin(MSG_ONE, 51, _, id);
	write_byte(strlen(text) + 2);
	write_byte(10);
	write_string(text);
	message_end();
}

// weapons

stock ham_give_weapon_by_name(id, weapon[])
{
	if(!equal(weapon, "weapon_", 7)) 
		return 0;

	new wEnt = engfunc(EngFunc_CreateNamedEntity, engfunc(EngFunc_AllocString, weapon));
	if(!pev_valid(wEnt)) 
		return 0;

	set_pev(wEnt,pev_spawnflags, SF_NORESPAWN);
	dllfunc(DLLFunc_Spawn, wEnt);

	if(!ExecuteHamB(Ham_AddPlayerItem, id, wEnt))
	{
		if(pev_valid(wEnt)) 
			set_pev(wEnt,pev_flags, pev(wEnt,pev_flags) | FL_KILLME);
		return 0;
	}

	ExecuteHamB(Ham_Item_AttachToPlayer, wEnt, id);
	return 1;
}

stock ham_strip_weapon_by_name(id, weapon[])
{
	if(!equal(weapon, "weapon_", 7)) 
		return 0;

	new wId = get_weaponid(weapon);
	if(!wId) 
		return 0;

	new wEnt;
	while((wEnt = engfunc(EngFunc_FindEntityByString, wEnt, "classname", weapon)) && pev(wEnt, pev_owner) != id) {}
	if(!wEnt) 
		return 0;

	if(get_user_weapon(id) == wId) 
		ExecuteHamB(Ham_Weapon_RetireWeapon, wEnt);

	if(!ExecuteHamB(Ham_RemovePlayerItem, id, wEnt))
		return 0;
	ExecuteHamB(Ham_Item_Kill, wEnt);

	set_pev(id, pev_weapons, pev(id,pev_weapons) & ~(1<<wId));

	return 1;
}

// removing entity 

stock delete_ent_by_class(classname[])
{
	new ent = find_ent_by_class(ent, classname);

	while(ent)
	{
		remove_entity(ent);
		ent = find_ent_by_class(ent, classname);
	}
}

// timer

stock string_timer(Float:flRealTime, szOutPut[], const iSizeOutPut, iMilliSecNumber = 2, gametime = true)
{
	static Float:flTime, iMinutes, iSeconds;
	
	flRealTime = flRealTime * 1000.0;

	if(gametime)
		flTime = get_gametime() * 1000.0 - flRealTime;
	else
		flTime = flRealTime;
	
	if(flTime < 0.0)
		flTime = -flTime;
	
	iMinutes = floatround(flTime / 60000.0, floatround_floor);
	flTime -= iMinutes * 60000;
	iSeconds = floatround(flTime / 1000.0, floatround_floor);
	flTime -= iSeconds * 1000;

	if(iMinutes <= 99)
		formatex(szOutPut, iSizeOutPut, "%02d:%02d", iMinutes, iSeconds);
	else
		formatex(szOutPut, iSizeOutPut, "%d:%02d", iMinutes, iSeconds);
	
	static iMilliSeconds;
	
	if(iMilliSecNumber == 1)
	{
		iMilliSeconds = floatround(flTime / 100, floatround_floor);
		format(szOutPut, iSizeOutPut, "%s.%01d", szOutPut, iMilliSeconds);
	}
	else if(iMilliSecNumber == 2)
	{
		iMilliSeconds = floatround(flTime / 10, floatround_floor);
		format(szOutPut, iSizeOutPut, "%s.%02d", szOutPut, iMilliSeconds);
	}
	else if(iMilliSecNumber == 3)
	{
		iMilliSeconds = floatround(flTime, floatround_floor);
		format(szOutPut, iSizeOutPut, "%s.%03d", szOutPut, iMilliSeconds);
	}
}

stock Float:float_timer(const szInPut[])
{
	new Float:flTime = 0.0;
	
	if(szInPut[2] == ':' && szInPut[5] == '.')
	{
		flTime+= ((szInPut[0] - 48) * 600.0) + ((szInPut[1] - 48) * 60.0);
		flTime+= ((szInPut[3] - 48) * 10.0) + (szInPut[4] - 48);
		flTime+= ((szInPut[6] - 48) / 10.0) + ((szInPut[7] - 48) / 100.0);
	}
	else
	{
		flTime = str_to_float(szInPut);
	}
	return flTime;
}

// menu

stock is_menu_opened(plaeyrId, menuId)
{
	new oldMenuId, newMenuId;
	player_menu_info(plaeyrId, oldMenuId, newMenuId);
	return (oldMenuId == menuId);
}

stock show_my_menu(index, keys, const menu[], time = -1, const title[] = "")
{
	const m_iMenu = 205;
	set_pdata_int(index, m_iMenu, 0);
	show_menu(index, keys, menu, time, title);
}

// IsUserSurfing by ConnorMcLeod (edited)

stock is_player_sliding(id)
{
	if(!is_user_alive(id))
		return 0;

	new iFlags = pev(id, pev_flags);
	if(iFlags & FL_ONGROUND)
		return 0;

	new Float:origin[3], Float:dest[3];
	pev(id, pev_origin, origin);

	dest[0] = origin[0];
	dest[1] = origin[1];
	dest[2] = origin[2] - 1.0;

	new ptr = create_tr2();
	engfunc(EngFunc_TraceHull, origin, dest, 0, (iFlags & FL_DUCKING) ? HULL_HEAD : HULL_HUMAN, id, ptr);
	new Float:flFraction;
	get_tr2(ptr, TR_flFraction, flFraction);
	if(flFraction >= 1.0)
	{
		free_tr2(ptr);
		return 0;
	}

	get_tr2(ptr, TR_vecPlaneNormal, dest);
	free_tr2(ptr);

	return dest[2] <= 0.7;
}

// localhost

stock is_user_localhost(id) 
{
	new szIP[16];
	get_user_ip(id, szIP, charsmax(szIP), 1);
	
	if(equal(szIP, "loopback") || equal(szIP, "127.0.0.1")) 
	{
		return true;
	}
	return false;
}

stock get_localhost()
{
	new players[32], pnum;
	
	get_players(players, pnum);

	for(new i = 0; i < pnum; i++)
	{
		if(is_user_localhost(players[i]))
			return players[i];
	}
	
	return 0;
}

// spec

stock is_spec_of_user(spec, id)
{
	return ( !is_user_alive(spec) && id == pev(spec, pev_iuser2) && (pev(spec, pev_iuser1) == 2 || pev(spec, pev_iuser1) == 4) );
}

// client director HUD

enum _:Properties 
{
	Color,
	Effect,
	AxisX,
	AxisY,
	FxTime,
	HoldTime,
	FadeInTime,
	FadeOutTime,
	Reliable
};

/*
stock g_iDHudProperties[Properties];

stock set_dhudmessage(red = 0, green = 160, blue = 0, Float:x = -1.0, Float:y = 0.65, effects = 2, Float:fxtime = 6.0, Float:holdtime = 3.0, Float:fadeintime = 0.1, Float:fadeouttime = 1.5, bool:reliable = false)
{
	#define clamp_byte(%1)       (clamp(%1, 0, 255))
	#define pack_color(%1,%2,%3) (%3 + (%2 << 8) + (%1 << 16))
	
	g_iDHudProperties[Color] = pack_color( clamp_byte(red), clamp_byte(green), clamp_byte(blue));
	g_iDHudProperties[AxisX] = _:x;
	g_iDHudProperties[AxisY] = _:y;
	g_iDHudProperties[Effect] = effects;
	g_iDHudProperties[FxTime] = _:fxtime;
	g_iDHudProperties[HoldTime] = _:holdtime;
	g_iDHudProperties[FadeInTime] = _:fadeintime;
	g_iDHudProperties[FadeOutTime] = _:fadeouttime;
	g_iDHudProperties[Reliable] = reliable;
}

stock show_dhudmessage(id, const szMsg[], any:...)
{	
	if(!id)
	{
		new iPlayers[32], iNum;
		get_players(iPlayers, iNum, "ch");
		if(!iNum)
			return;
	}
	
	if(!is_user_connected(id))	
		return;
	
	new szMessage[128];
	new iParams = numargs();
	
	if(iParams == 2)
		copy(szMessage, sizeof(szMessage) - 1, szMsg);
	else
		vformat(szMessage, sizeof(szMessage) - 1, szMsg, 3);

	Send_DHudMessage(id, szMessage);
}

stock Send_DHudMessage(iReceiver, szMessage[])
{
	message_begin(g_iDHudProperties[Reliable] ? (iReceiver ? MSG_ONE : MSG_ALL) : (iReceiver ? MSG_ONE_UNRELIABLE : MSG_BROADCAST), SVC_DIRECTOR, .player = iReceiver); 
	{
		write_byte(strlen(szMessage) + 31);
		write_byte(DRC_CMD_MESSAGE);
		write_byte(g_iDHudProperties[Effect]);
		write_long(g_iDHudProperties[Color]);
		write_long(g_iDHudProperties[AxisX]);
		write_long(g_iDHudProperties[AxisY]);
		write_long(g_iDHudProperties[FadeInTime]);
		write_long(g_iDHudProperties[FadeOutTime]);
		write_long(g_iDHudProperties[HoldTime]);
		write_long(g_iDHudProperties[FxTime]);
		write_string(szMessage);
	}
	message_end();
}
*/

// colorchat

enum ColorType
{
	NORMAL = 1, // clients scr_concolor cvar color
	GREEN, // green color
	TEAM_COLOR, // red, grey, blue
	GREY, // grey
	RED, // red
	BLUE, // blue
};

new Team_Name[][] = 
{
	"",
	"TERRORIST",
	"CT",
	"SPECTATOR"
};

stock client_print_f(id, ColorType:type, const msg[], {Float,Sql,Result,_}:...)
{
	new message[256];

	switch(type)
	{
		case NORMAL: // clients scr_concolor cvar color
			message[0] = 0x01;
		case GREEN: // green
			message[0] = 0x04;
		default: // white, red, blue
			message[0] = 0x03;
	}

	vformat(message[1], 251, msg, 4);

	// make sure message is not longer than 192 character. Will crash the server.
	message[192] = '^0';

	new team, ColorChange, index, MSG_Type;
	
	if(id)
	{
		MSG_Type = MSG_ONE;
		index = id;
	} 
	else 
	{
		index = FindPlayer();
		MSG_Type = MSG_ALL;
	}
	
	team = get_user_team(index);

	// if(index > 0)
	// 	team = get_pdata_int(index, 114);
	// else
	// 	team = 0;
	
	if(team >= 0 && team < 4)
    {
		ColorChange = ColorSelection(index, MSG_Type, type);

		ShowColorMessage(index, MSG_Type, message);
		
		if(ColorChange)
		{
			Team_Info(index, MSG_Type, Team_Name[team]);
		}
	}
}

stock ShowColorMessage(id, type, message[])
{
	static bool:saytext_used;
	static get_user_msgid_saytext;
	if(!saytext_used)
	{
		get_user_msgid_saytext = get_user_msgid("SayText");
		saytext_used = true;
	}
	message_begin(type, get_user_msgid_saytext, _, id);
	write_byte(id);		
	write_string(message);
	message_end();	
}

stock Team_Info(id, type, team[])
{
	static bool:teaminfo_used;
	static get_user_msgid_teaminfo;
	if(!teaminfo_used)
	{
		get_user_msgid_teaminfo = get_user_msgid("TeamInfo");
		teaminfo_used = true;
	}
	message_begin(type, get_user_msgid_teaminfo, _, id);
	write_byte(id);
	write_string(team);
	message_end();

	return 1;
}

stock ColorSelection(index, type, ColorType:Type)
{
	switch(Type)
	{
		case RED:
			return Team_Info(index, type, Team_Name[1]);
		case BLUE:
			return Team_Info(index, type, Team_Name[2]);
		case GREY:
			return Team_Info(index, type, Team_Name[0]);
	}

	return 0;
}

stock FindPlayer()
{
	new i = -1;

	while(i <= get_maxplayers())
	{
		if(is_user_connected(++i))
			return i;
	}

	return -1;
}